<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'autoload.php';

use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;

define("MERCHANT_LOGIN_ID", "63YPu6bW"); 
define("MERCHANT_TRANSACTION_KEY", "963yjqV3cP8Xc2MM"); 

function createCustomerWithPaymentProfile(
    $cardNumber,
    $cardExpiryDate,
    $cardCode,
    $description = null,
    $address = null,
    $customerId = null
) {
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    $merchantAuthentication->setName(MERCHANT_LOGIN_ID);
    $merchantAuthentication->setTransactionKey(MERCHANT_TRANSACTION_KEY);

    $creditCard = new AnetAPI\CreditCardType();
    $creditCard->setCardNumber($cardNumber);
    $creditCard->setExpirationDate($cardExpiryDate);
    $creditCard->setCardCode($cardCode);

    $paymentCreditCard = new AnetAPI\PaymentType();
    $paymentCreditCard->setCreditCard($creditCard);

    //$paymentProfile = new AnetAPI\CustomerPaymentProfileType();
    //$paymentProfile->setCustomerType('individual');
	
    $customerPaymentProfile = new AnetAPI\CustomerPaymentProfileType();
    $customerPaymentProfile->setCustomerType('individual');
    $customerPaymentProfile->setPayment($paymentCreditCard);	

    if ($address !== null) {
        $billTo = new AnetAPI\CustomerAddressType();
        $billTo->setFirstName($address['firstName']);
        $billTo->setLastName($address['lastName']);
        $billTo->setCompany($address['company']);
        $billTo->setAddress($address['address']);
        $billTo->setCity($address['city']);
        $billTo->setState($address['state']);
        $billTo->setZip($address['zip']);
        $billTo->setCountry($address['country']);
        $billTo->setPhoneNumber($address['phone']);

		$customerPaymentProfile->setBillTo($billTo);	
	}
	

	$paymentProfiles[] = $customerPaymentProfile;

    $customerProfile = new AnetAPI\CustomerProfileType();
    $customerProfile->setDescription($description);
	$customerProfile->setEmail($address['email']); 
	$customerProfile->setMerchantCustomerId($customerId);
	$customerProfile->setPaymentProfiles($paymentProfiles);	
	
    $request = new AnetAPI\CreateCustomerProfileRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setProfile($customerProfile);

    $controller = new AnetController\CreateCustomerProfileController($request);
    $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);

    if (($response != null) && ($response->getMessages()->getResultCode() == "Ok")) {
        $customerProfileId = $response->getCustomerProfileId();
        $customerPaymentProfileId = $response->getCustomerPaymentProfileIdList()[0];

        echo "Create Customer Profile with Payment Profile SUCCESS:\n";
        echo "Customer Profile ID: " . $customerProfileId . "\n";
        echo "Payment Profile ID: " . $customerPaymentProfileId . "\n";
    } else {
        echo "Create Customer Profile with Payment Profile ERROR: Invalid response\n";
        $errorMessages = $response->getMessages()->getMessage();
        foreach ($errorMessages as $msg) {
            $errorMsg = "Response: " . $msg->getCode() . "  " . $msg->getText() . "\n";
            echo $errorMsg;
            error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
        }
    }

    return $response;
}


//In the error_log() function, the second parameter "3" means we are writing the error message to a file, and the third parameter "/path/to/your/error.log" is the path to the error log file.
//The __DIR__ . "/error.log" part will create a path that's always in the same directory as the PHP script, which can be useful if your script might be run from different locations.

/*$customerProfileId: The ID of the customer profile associated with the payment. // user ID in AWS
$customerPaymentProfileId: The ID of the payment profile within the customer profile to charge. // GET FROM DB members table
$amount
$refId/ By providing a unique $refId for each transaction, you can easily track and reference specific requests when reviewing logs, troubleshooting issues, or reconciling data.*/

$cardNumber = "4111111111111111";
$cardExpiryDate = "1225"; // December 2025
$cardCode = "123";
$description = "SAAS Services";
$email = "test@example.com";

$firstName = 'John';
$lastName = 'Doe';
$company = 'ABC Company';
$address1 = '123 Main Street';
$city = 'Anytown';
$state = 'NY';
$zip = '12345';
$country = 'United States';
$phone = '123-456-7890';

$shippingFirstName = 'Jane';
$shippingLastName = 'Smith';
$shippingCompany = 'XYZ Corporation';
$shippingAddress = '456 Shipping Avenue';
$shippingCity = 'Some City';
$shippingState = 'CA';
$shippingZip = '98765';
$shippingCountry = 'United States';
$shippingPhone = '987-654-3210';

$customerId = '107';
	
$address = array(
    'firstName' => $firstName,
    'lastName' => $lastName,
    'company' => $company,
    'address' => $address1,
    'city' => $city,
    'state' => $state,
    'zip' => $zip,
    'country' => $country,
    'phone' => $phone,
    'email' => $email,
);

$shippingAddress = array(
    'shippingFirstName' => $shippingFirstName,
    'shippingLastName' => $shippingLastName,
    'shippingCompany' => $shippingCompany,
    'shippingAddress' => $shippingAddress,
    'shippingCity' => $shippingCity,
    'shippingState' => $shippingState,
    'shippingZip' => $shippingZip,
    'shippingCountry' => $shippingCountry,
    'shippingPhone' => $shippingPhone
);
	

//createCustomerWithPaymentProfile($cardNumber, $cardExpiryDate, $cardCode, $description, $address, $customerId);

// CODE SENT BACK!
//Customer Profile ID: 512731566 Payment Profile ID: 519492466
// 512731975 Payment Profile ID: 519492925
$customerProfileId =  512731975;
$customerPaymentProfileId = 519492925;
$amount = 13.00;
$refId = 8;
$description = "URL Forwarding";
$invoiceNumber = 777;
$tax = 5.05;
$freight = 3.45;
$duty = 4.07;

chargeAWSCustomerProfile($customerProfileId, $customerPaymentProfileId, $amount, $refId);

use net\authorize\api\contract\v1\OrderType;
use net\authorize\api\contract\v1\ExtendedAmountType;

function chargeAWSCustomerProfile($customerProfileId, $customerPaymentProfileId, $amount, $refId = null, $shippingAddress = null, $description = null, $invoiceNumber = null, $tax = null, $freight = null, $duty = null)
{
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    $merchantAuthentication->setName(MERCHANT_LOGIN_ID);
    $merchantAuthentication->setTransactionKey(MERCHANT_TRANSACTION_KEY);

    // Determine the environment based on the credentials
    $environment = \net\authorize\api\constants\ANetEnvironment::SANDBOX;

    $profileToCharge = new AnetAPI\CustomerProfilePaymentType();
    $profileToCharge->setCustomerProfileId($customerProfileId);
    $paymentProfile = new AnetAPI\PaymentProfileType();
    $paymentProfile->setPaymentProfileId($customerPaymentProfileId);
    $profileToCharge->setPaymentProfile($paymentProfile);

    $transactionRequestType = new AnetAPI\TransactionRequestType();
    $transactionRequestType->setTransactionType("authCaptureTransaction");
    $transactionRequestType->setAmount($amount);
    $transactionRequestType->setProfile($profileToCharge);

    // Set the order description
    $order = new OrderType();
    $order->setDescription($description);
    $order->setInvoiceNumber($invoiceNumber);
    $transactionRequestType->setOrder($order);

    // Set the shipping address
    if ($shippingAddress !== null) {
        $shipTo = new AnetAPI\CustomerAddressType();
        $shipTo->setFirstName($shippingAddress['firstName']);
        $shipTo->setLastName($shippingAddress['lastName']);
        $shipTo->setCompany($shippingAddress['company']);
        $shipTo->setAddress($shippingAddress['address']);
        $shipTo->setCity($shippingAddress['city']);
        $shipTo->setState($shippingAddress['state']);
        $shipTo->setZip($shippingAddress['zip']);
        $shipTo->setCountry($shippingAddress['country']);
        $shipTo->setPhoneNumber($shippingAddress['phone']);
        $transactionRequestType->setShipTo($shipTo);
    }

    // Set additional details (tax, freight, duty)
    $extendedAmounts = [];
    if ($tax !== null) {
        $taxAmount = new LineItemType();
        $taxAmount->setName("Tax");
        $taxAmount->setTaxAmount($tax);
        $extendedAmounts[] = $taxAmount;
    }
    if ($freight !== null) {
        $freightAmount = new ExtendedAmountType();
        $freightAmount->setName("Freight");
        $freightAmount->setAmount($freight);
        $extendedAmounts[] = $freightAmount;
    }
    if ($duty !== null) {
        $dutyAmount = new ExtendedAmountType();
        $dutyAmount->setName("Duty");
        $dutyAmount->setAmount($duty);
        $extendedAmounts[] = $dutyAmount;
    }
    if (!empty($extendedAmounts)) {
        $transactionRequestType->setExtendedAmounts($extendedAmounts);
    }

    $request = new AnetAPI\CreateTransactionRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setRefId($refId);
    $request->setTransactionRequest($transactionRequestType);

    $controller = new AnetController\CreateTransactionController($request);
    $response = $controller->executeWithApiResponse($environment);

    if ($response != null) {
        if ($response->getMessages()->getResultCode() == "Ok") {
            $transactionId = $response->getTransactionResponse()->getTransId();
            echo "Charge Customer Profile SUCCESS: " . $transactionId . "\n";
            echo '<pre>';
            print_r($response);
            echo '</pre>';

        } else {
            echo "Charge Customer Profile ERROR: Invalid response\n";
            $errorMessages = $response->getMessages()->getMessage();
            foreach ($errorMessages as $msg) {
                $errorMsg = "Response: " . $msg->getCode() . "  " . $msg->getText() . "\n";
                echo $errorMsg;
                error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
            }
            $transactionResponseErrors = $response->getTransactionResponse()->getErrors();
            foreach ($transactionResponseErrors as $error) {
                $errorMsg = "Transaction Error: " . $error->getErrorCode() . "  " . $error->getErrorText() . "\n";
                echo $errorMsg;
                error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
            }
        }
    } else {
        echo "Charge Customer Profile ERROR: Null response\n";
    }

    return $response;
}

?>